///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool OpenLogFile(void)
{
    char FullFileName[256];

    SYSTEMTIME ST;

    GetLocalTime(&ST);

    char DateTemp[64 + 1];
    char TimeTemp[64 + 1];

    GetDateFormat(LOCALE_USER_DEFAULT, NULL, &ST, "MM-dd-yy", DateTemp,64);
    GetTimeFormat(LOCALE_USER_DEFAULT, NULL, &ST, "hh-mm-ss-tt", TimeTemp,64);

    sprintf(FullFileName, "%s\\%s %s %d.txt", gsSessionLogDir, DateTemp, TimeTemp, ST.wMilliseconds);

    if( (gfSessionLog = fopen(FullFileName, "wb")) == NULL)
        return false;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Initialize(void)
{
    if(!GetRegistryValues())
    {
		FatalError("Error getting registry values!");
        return false;
    }

    if(!OpenLogFile())
    {
        FatalError("Failed to open log file");
        return false;
    }

    InitializeCRCTable();

    // -----------------------------------------------------

    if(!InitCryptography())
    {
		FatalError("Error initializing cryptography!");
        return false;
    }

    InitClientInfo();

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Uninitialize(void)
{
    if(!UninitCryptography())
        return false;

    if(gfSessionLog) fclose(gfSessionLog);

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

